/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsbc.dimensions.kubejs;

import dev.ftb.ftbsbc.dimensions.kubejs.StoneBlockLayerKjs;
import dev.ftb.ftbsbc.dimensions.prebuilt.PrebuiltStructure;
import dev.latvian.mods.rhino.mod.util.color.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class StoneBlockDataKjs {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Random RANDOM = new Random();
    public static boolean debugMode = false;
    public static final List<StoneBlockDataKjs> BIOMES = new ArrayList<StoneBlockDataKjs>();
    public static final Map<String, PrebuiltStructure> PREBUILT_STRUCTURES = new LinkedHashMap<String, PrebuiltStructure>();
    public static final PositionalRandomFactory RANDOM_FACTORY = new LegacyRandomSource.LegacyPositionalRandomFactory(0L);
    private static int totalDistance = 1;
    public static ResourceLocation lobbyStructure = null;
    public int index;
    public String uniqueId;
    public final ResourceKey<Biome> biome;
    private final int startsAt;
    private final List<StoneBlockLayerKjs> layerList;
    private StoneBlockLayerKjs[] layers;
    public int biomeColor;
    public int blend;
    public boolean carvers;

    public static void reset() {
        PREBUILT_STRUCTURES.clear();
        BIOMES.clear();
        totalDistance = 0;
        lobbyStructure = null;
    }

    public static void setLobbyStructure(ResourceLocation location) {
        lobbyStructure = location;
    }

    public static PrebuiltStructure addStart(ResourceLocation id, Component name, String author) {
        PrebuiltStructure start = new PrebuiltStructure(id, name, author);
        PREBUILT_STRUCTURES.put(id.toString(), start);
        return start;
    }

    public static PrebuiltStructure addStart(ResourceLocation id, Component name) {
        return StoneBlockDataKjs.addStart(id, name, "FTB Team");
    }

    public static StoneBlockDataKjs addBiome(ResourceLocation biome, int size) {
        StoneBlockDataKjs config = new StoneBlockDataKjs((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)biome), totalDistance);
        BIOMES.add(config);
        BIOMES.sort(Comparator.comparingInt(StoneBlockDataKjs::getOrder));
        for (int i = 0; i < BIOMES.size(); ++i) {
            StoneBlockDataKjs.BIOMES.get((int)i).index = i;
        }
        totalDistance += size;
        return config;
    }

    public static StoneBlockDataKjs getConfig(int distance) {
        int dist = distance % totalDistance;
        for (StoneBlockDataKjs config : BIOMES) {
            if (dist < config.startsAt) continue;
            return config;
        }
        return BIOMES.get(0);
    }

    public static StoneBlockDataKjs getConfig(int x, int z) {
        int d;
        int distance = (int)Math.sqrt(x * x + z * z);
        StoneBlockDataKjs data = StoneBlockDataKjs.getConfig(distance);
        if (data.blend > 0 && (d = RANDOM_FACTORY.m_183161_(x, 0, z).nextInt(data.blend)) > 0) {
            return StoneBlockDataKjs.getConfig(distance + d);
        }
        return data;
    }

    public static int getColor(ServerLevel level, BlockPos pos) {
        if (pos.m_123341_() == 0 && pos.m_123343_() == 0) {
            return -16711936;
        }
        return StoneBlockDataKjs.getConfig((int)pos.m_123341_(), (int)pos.m_123343_()).biomeColor;
    }

    public static List<Holder<Biome>> createBiomes(Registry<Biome> r) {
        ArrayList<Holder<Biome>> list = new ArrayList<Holder<Biome>>();
        for (StoneBlockDataKjs config : BIOMES) {
            list.add((Holder<Biome>)r.m_206081_(config.biome));
        }
        return list;
    }

    public static void finish() {
        HashSet<String> uniqueIds = new HashSet<String>();
        for (StoneBlockDataKjs config : BIOMES) {
            config.uniqueId = config.biome.m_135782_().m_135815_();
            int c = 2;
            while (uniqueIds.contains(config.uniqueId)) {
                config.uniqueId = config.biome.m_135782_().m_135815_() + "_" + c;
                ++c;
            }
            uniqueIds.add(config.uniqueId);
            config.finishConfig();
        }
    }

    public static int getDefaultMaxDistance() {
        return Math.min(Mth.m_14165_((double)((double)totalDistance * 1.1)), 10000);
    }

    public StoneBlockDataKjs(ResourceKey<Biome> biome, int startsAt) {
        this.biome = biome;
        this.startsAt = startsAt;
        this.layerList = new ArrayList<StoneBlockLayerKjs>();
        this.biomeColor = RANDOM.nextInt() | 0xFF000000;
        this.blend = 40;
        this.carvers = false;
    }

    public String toString() {
        return this.uniqueId;
    }

    public void setColor(Color s) {
        int rgb = s.getRgbJS();
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        this.biomeColor = 0xFF000000 | b << 16 | g << 8 | r;
    }

    public void addLayer(String layer) {
        this.layerList.add(new StoneBlockLayerKjs(layer));
    }

    public void finishConfig() {
        if (this.layerList.isEmpty()) {
            this.layerList.add(new StoneBlockLayerKjs("minecraft:stone"));
            LOGGER.error("No layers added in " + this.biome.m_135782_());
        }
        this.layers = new StoneBlockLayerKjs[128];
        StoneBlockLayerKjs lastLayer = this.layerList.get(this.layerList.size() - 1);
        Arrays.fill(this.layers, lastLayer);
        int index = 0;
        block0: for (StoneBlockLayerKjs layer : this.layerList) {
            if (layer == lastLayer) break;
            for (int y = 0; y < layer.size; ++y) {
                this.layers[index] = layer;
                if (++index == this.layers.length) break block0;
            }
        }
        if (debugMode) {
            LOGGER.info("=== Debug layer output of " + this.biome.m_135782_() + " ===");
            for (int i = 0; i < this.layers.length; ++i) {
                LOGGER.info(String.format("[%03d] %s", i, this.layers[i].block));
            }
        }
    }

    public StoneBlockLayerKjs getLayer(int y) {
        return this.layers[Mth.m_14045_((int)Math.abs(y), (int)0, (int)(this.layers.length - 1))];
    }

    public BlockState getState(int x, int y, int z) {
        if (!(debugMode || y != -128 && y != 127)) {
            return Blocks.f_50752_.m_49966_();
        }
        if (debugMode && (x >> 6 & 1) == (z >> 6 & 1)) {
            return Blocks.f_50016_.m_49966_();
        }
        int ay = Math.abs(y);
        RandomSource random = RANDOM_FACTORY.m_183161_(x, y, z);
        return this.getLayer(ay + random.nextInt(7) - 3).getState();
    }

    public void fillColumn(int x, int z, BlockState[] states) {
        for (int i = 0; i < states.length; ++i) {
            states[i] = this.getState(x, i - 128, z);
        }
    }

    private int getOrder() {
        return -this.startsAt;
    }
}

